package com.group_finity.mascot;

import java.awt.image.BufferedImage;

import com.group_finity.mascot.environment.Environment;
import com.group_finity.mascot.image.NativeImage;
import com.group_finity.mascot.image.TranslucentWindow;
import com.sun.jna.Platform;

/**
 * lCeBuւ̃ANZX񋟂.
 * {@link #getInstance()} ͎sɂ Windows p邢͔ėp̃TuNX̃CX^XԂ.
 * @author Yuki
 */
public abstract class NativeFactory {

	private static final NativeFactory instance;

	/**
	 * TuNX̃CX^X쐬Ă.
	 */
	static {
		final String basePackage = NativeFactory.class.getName().substring(0, NativeFactory.class.getName().lastIndexOf('.'));

		final String subPackage = Platform.isWindows() ? "win" : "generic";

		try {
			final Class<? extends NativeFactory> impl = (Class<? extends NativeFactory>)Class.forName(basePackage+"."+subPackage+".NativeFactoryImpl");

			instance = impl.newInstance();

		} catch (final ClassNotFoundException e) {
			throw new RuntimeException(e);
		} catch (final InstantiationException e) {
			throw new RuntimeException(e);
		} catch (final IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * sɉTuNX̃CX^X擾.
	 * @return
	 */
	public static NativeFactory getInstance() {
		return instance;
	}

	/**
	 * IuWFNg擾.
	 * @return IuWFNg.
	 */
	public abstract Environment getEnvironment();

	/**
	 * w肳ꂽ BufferedImage ɑΉlCeBuȉ摜擾.
	 * ̉摜 {@link TranslucentWindow} ̃}XLOɎgpł.
	 * @param src
	 * @return
	 */
	public abstract NativeImage newNativeImage(BufferedImage src);

	/**
	 * \\ȃEBhE쐬.
	 * @return
	 */
	public abstract TranslucentWindow newTransparentWindow();
}
