package com.group_finity.mascot;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.image.MascotImage;
import com.group_finity.mascot.image.TranslucentWindow;

/**
 * }XRbgIuWFNg.
 *
 * }XRbg͒IŕGȐU镑킷 {@link Behavior} ƁA
 * ZIŒPȓ\ {@link Action} œ.
 *
 * }XRbg͓IɃ^C}ĂāAԊuƂ {@link Action} Ăяo.
 * {@link Action}  {@link #animate(Point, MascotImage, boolean)} \bhȂǂĂԂƂ
 * }XRbgAj[V.
 *
 * {@link Action} IȂ̓̃^C~O {@link Behavior} ĂяoA {@link Action} Ɉڂ.
 *
 */
public class Mascot {

	private static final long serialVersionUID = 1L;

	private static final Logger log = Logger.getLogger(Mascot.class.getName());

	/**
	 * Ōɐ}XRbgID.
	 */
	private static AtomicInteger lastId = new AtomicInteger();

	/**
	 * }XRbgID.
	 * fobOp̃O₷邽߂ɑ݂.
	 */
	private final int id;

	/**
	 * }XRbg\EBhE.
	 */
	private final TranslucentWindow window = NativeFactory.getInstance().newTransparentWindow();

	/**
	 * }XRbgǗĂ}l[W.
	 */
	private Manager manager = null;

	/**
	 * }XRbg̐ڒnW.
	 * ƂΑAԂ牺ĂƂ̎̕Ȃ.
	 * 摜\Ƃ̒SɂȂ.
	 */
	private Point anchor = new Point(0, 0);

	/**
	 * \摜.
	 */
	private MascotImage image = null;

	/**
	 * Eǂ.
	 * IWi摜͍ƂĈ̂ŁAtrueݒ肷Ɣ]ĕ`悳.
	 */
	private boolean lookRight = false;

	/**
	 * IȐU镑킷IuWFNg.
	 */
	private Behavior behavior = null;

	/**
	 * ^C}[1`bNƂɑ鎞.
	 */
	private int time = 0;

	/**
	 * Aj[Vsǂ.
	 */
	private boolean animating = true;

	/**
	 * }XRbg̕\.
	 */
	private MascotEnvironment environment = new MascotEnvironment(this);

	public Mascot() {
		this.id = lastId.incrementAndGet();

		log.log(Level.INFO, "}XRbg({0})", this);

		// ɍőPʂɕ\
		getWindow().asJWindow().setAlwaysOnTop(true);

		// }EXnho^
		getWindow().asJWindow().addMouseListener(new MascotEventHandler(this));

	}

	@Override
	public String toString() {
		return "}XRbg" + this.id;
	}

	void tick() {
		if (isAnimating()) {
			if (getBehavior() != null) {

				try {
					getBehavior().next();
				} catch (final CantBeAliveException e) {
					log.log(Level.SEVERE, "邱ƂoȂ", e);
					dispose();
				}

				setTime(getTime() + 1);
			}
		}
	}

	public void apply() {
		if (isAnimating()) {

			// \ł摜ΉoȂ
			if (getImage() != null) {

				// EBhË̗ݒ
				getWindow().asJWindow().setBounds(getBounds());

				// 摜ݒ
				getWindow().setImage(getImage().getImage());

				// \
				if (!getWindow().asJWindow().isVisible()) {
					getWindow().asJWindow().setVisible(true);
				}

				// ĕ`
				getWindow().updateImage();
			} else {
				if (getWindow().asJWindow().isVisible()) {
					getWindow().asJWindow().setVisible(false);
				}
			}
		}
	}

	public void dispose() {
		log.log(Level.INFO, "}XRbgj({0})", this);

		getWindow().asJWindow().dispose();
		if (getManager() != null) {
			getManager().remove(Mascot.this);
		}
	}

	public Manager getManager() {
		return this.manager;
	}

	public void setManager(final Manager manager) {
		this.manager = manager;
	}

	public Point getAnchor() {
		return this.anchor;
	}

	public void setAnchor(final Point anchor) {
		this.anchor = anchor;
	}

	public MascotImage getImage() {
		return this.image;
	}

	public void setImage(final MascotImage image) {
		this.image = image;
	}

	public boolean isLookRight() {
		return this.lookRight;
	}

	public void setLookRight(final boolean lookRight) {
		this.lookRight = lookRight;
	}

	public Rectangle getBounds() {

		// ڒnWƉ摜̒SWEBhË̗߂.
		final int top = getAnchor().y - getImage().getCenter().y;
		final int left = getAnchor().x - getImage().getCenter().x;

		final Rectangle result = new Rectangle(left, top, getImage().getSize().width, getImage().getSize().height);

		return result;
	}

	public int getTime() {
		return this.time;
	}

	private void setTime(final int time) {
		this.time = time;
	}

	public Behavior getBehavior() {
		return this.behavior;
	}

	public void setBehavior(final Behavior behavior) throws CantBeAliveException {
		this.behavior = behavior;
		this.behavior.init(this);
	}

	public int getTotalCount() {
		return getManager().getCount();
	}

	private boolean isAnimating() {
		return this.animating;
	}

	void setAnimating(final boolean animating) {
		this.animating = animating;
	}

	TranslucentWindow getWindow() {
		return this.window;
	}

	public MascotEnvironment getEnvironment() {
		return environment;
	}
}
