/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.win;

import com.group_finity.mascot.image.NativeImage;
import com.group_finity.mascot.image.TranslucentWindow;
import com.group_finity.mascot.win.WindowsNativeImage;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JWindow;

class WindowsTranslucentWindow
extends JWindow
implements TranslucentWindow {
    private static final long serialVersionUID = 1L;
    private WindowsNativeImage image;
    private int alpha = 255;

    WindowsTranslucentWindow() {
    }

    public static void main(String[] args) throws IOException {
        WindowsTranslucentWindow win = new WindowsTranslucentWindow();
        win.setVisible(true);
        win.setBounds(0, 0, 200, 200);
        BufferedImage img = ImageIO.read(new File("img/shime1.png"));
        WindowsNativeImage wi = new WindowsNativeImage(img);
        win.setImage(wi);
        win.repaint();
    }

    @Override
    public JWindow asJWindow() {
        return this;
    }

    private void paint(WinDef.HBITMAP imageHandle, int alpha) {
        WinDef.HWND hWnd = new WinDef.HWND(Native.getComponentPointer(this));
        if (User32.INSTANCE.IsWindowVisible(hWnd)) {
            int exStyle = User32.INSTANCE.GetWindowLong(hWnd, -20);
            if ((exStyle & 0x80000) == 0) {
                User32.INSTANCE.SetWindowLong(hWnd, -20, exStyle | 0x80000);
            }
            WinDef.HDC clientDC = User32.INSTANCE.GetDC(hWnd);
            WinDef.HDC memDC = GDI32.INSTANCE.CreateCompatibleDC(clientDC);
            WinNT.HANDLE oldBmp = GDI32.INSTANCE.SelectObject(memDC, imageHandle);
            User32.INSTANCE.ReleaseDC(hWnd, clientDC);
            WinDef.RECT windowRect = new WinDef.RECT();
            User32.INSTANCE.GetWindowRect(hWnd, windowRect);
            WinUser.BLENDFUNCTION bf = new WinUser.BLENDFUNCTION();
            bf.BlendOp = 0;
            bf.BlendFlags = 0;
            bf.SourceConstantAlpha = (byte)alpha;
            bf.AlphaFormat = 1;
            WinUser.POINT lt = new WinUser.POINT();
            lt.x = windowRect.left;
            lt.y = windowRect.top;
            WinUser.SIZE size = new WinUser.SIZE();
            size.cx = windowRect.right - windowRect.left;
            size.cy = windowRect.bottom - windowRect.top;
            WinUser.POINT zero = new WinUser.POINT();
            User32.INSTANCE.UpdateLayeredWindow(hWnd, null, lt, size, memDC, zero, 0, bf, 2);
            GDI32.INSTANCE.SelectObject(memDC, oldBmp);
            GDI32.INSTANCE.DeleteDC(memDC);
        }
    }

    @Override
    public String toString() {
        return "LayeredWindow[hashCode=" + this.hashCode() + ",bounds=" + this.getBounds() + "]";
    }

    @Override
    public void paint(Graphics g) {
        if (this.getImage() != null) {
            this.paint(this.getImage().getHandle(), this.getAlpha());
        }
    }

    private WindowsNativeImage getImage() {
        return this.image;
    }

    @Override
    public void setImage(NativeImage image) {
        this.image = (WindowsNativeImage)image;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public void updateImage() {
        this.repaint();
    }
}

